-- moonIcons: the return of dubaiOne's custom OptionsIcons.

local Player = ...;
assert(Player);
local pname = playername(Player);
--------------------------------------------------------------------------------
--[[ configuration ]]
local spacingX = 47; -- should really be width of icon - 1
local spacingY = -16; -- this means they go up, this should be configurable easier.

local numRows = 1;
local numCols = 6;
--------------------------------------------------------------------------------

local c;
-- make the ActorFrame to store the icons.
local u = Def.ActorFrame{
	Name="OptionIconRow"..pname;
	OnCommand=cmd(playcommand,"Update");
	UpdateCommand=function(self)
		-- get the options.
		local PlayerState = GAMESTATE:GetPlayerState(Player);
		-- grab the song options from this PlayerState.
		local options = PlayerState:GetPlayerOptions('ModsLevel_Preferred');
		-- now using split, let's put them into a table for comparison
		local listOfOptions = split(", ", options);
		-- find out how many options are in play.
		local numOptions = #listOfOptions;

		-- right now, let's keep it simple and to one line.
		local iconMain, iconImage, iconText;
		for row=1,numRows do
			for i=1,numCols do
				iconMain = self:GetChild( pname.."ModIcon"..i );
				iconImage = iconMain:GetChild("Icon");
				iconText = iconMain:GetChild("Label");

				local text = listOfOptions[i] or "";
				iconText:settext(text);
				if text == "" then
					iconImage:diffuse( color("1,1,1,1") );
				else
					iconImage:diffuse( PlayerColor(Player) );
				end;
				iconImage:diffusealpha(0.75);
			end;
		end;
	end;
	PlayerOptionsChangedMessageCommand=function(self,param)
		if param.PlayerNumber == Player then
			self:playcommand("Update");
		end;
	end;
};

local function MakeIcons()
	for i=1,numCols do
		u[#u+1] = Def.ActorFrame{
			Name=pname.."ModIcon"..i;
			-- xxx: should determine spacing some other way
			-- for multiple rows
			InitCommand=cmd(x,((i-1) * spacingX);y,0;diffusealpha,0.8);

			LoadActor("_optionicon")..{
				Name="Icon";
			};
			AutoText("frutiger",true)..{
				Name="Label";
				Text="";
				InitCommand=cmd(zoom,0.5;diffuse,color("#FFFFFF");NoStroke;shadowlength,1;maxwidth,90);
			};
		};
	end;
end;

u.InitCommand=MakeIcons();

return u;